// Program 6 DPCM encoding and decoding of images
//Software version
//OS Windows7
//Scilab5.4.1
//Image Processing Design Toolbox 8.3.1-1
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2
clc
clear
//Function to find number of elements in an image
function [N] = numel(X)
    //X-input image
    //N- number of elements in image X
    [m,n]= size(X);
    N = m*n;
endfunction
///////////////////////////////////////////////////////////////////////////////
//Function to calculate peak signal to noise ratio
function [psnr,mse,maxerr] = psnr_mse_maxerr(X,Xapp)
//PSNR_MSE_MAXERR Peak signal to noise ratio 
//X - original Image
//Xapp - reconstructed image
//psnr - peak signal to noise ratio
//mse - mean square error
//maxerr -  maximum error
X    = double(X);
Xapp = double(Xapp);
absD = abs(X-Xapp);
A    = absD.^2;
mse  = sum(A(:))/numel(X);
psnr = 10*log10(255*255/mse);
maxerr = round(max(absD(:)));
endfunction
//////////////////////////////////////////////////////////////////////////////
a=imread('C:\Users\senthilkumar\Desktop\Chandra_Mohan_LAB\Digital_Image_ProcessingLab\cameraman.jpeg');
a=double(a);
[m n]=size(a);
pre=0;
q=input('enter the quantization value');
for i=1:m
    for j=1:n
        t1=a(i,j)-pre;
        tq=round(t1/q);
        pre=pre+tq*q;
        b(i,j)=tq;
    end
end
repre=0;
for i=1:m
    for j=1:n
        ret=b(i,j);
        inq=ret*q;
        repre=repre+inq;
        c(i,j)=repre;
    end
end
figure
ShowImage(a,'Image Before Quantization')
figure
ShowImage(b,'Quantized Image')
figure
ShowImage(c,'Reconstructed Image From Quantized Image')
psnr = psnr_mse_maxerr(a,c);
disp(psnr,'PSNR in dB= ')
//RESULT
//enter the quantization value 2
//PSNR in dB =  51.165559 

//enter the quantization value 8
//PSNR in dB =  40.698164
//
